//
//  LogProvider
//  dJAX
//
//  Copyright (c) 2014 dJAX. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "Logging.h"

@protocol MPLogger;

@interface LogProvider : NSObject

+ (LogProvider *)sharedLogProvider;
- (void)addLogger:(id<MPLogger>)logger;
- (void)removeLogger:(id<MPLogger>)logger;
- (void)logMessage:(NSString *)message atLogLevel:(dJAXLogLevel)logLevel;

@end

@protocol MPLogger <NSObject>

- (dJAXLogLevel)logLevel;
- (void)logMessage:(NSString *)message;

@end
